#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "types.h"
#include "Bounce.h"
#include "SurfaceGeometry.h"
#include "Rod.h"

/* Compute vector displacement from one vertex to another. */
extern vert u[];
static vec vsub(vec a, vec b) // vector difference
  {vec d; int i; for (i=0; i<3; i++) d.a[i]=a.a[i]-b.a[i]; return d;}
vec cdvec(int i, int j) {return vsub(u[j].wh, u[i].wh);}
/* Cross product of two vectors */
static vec cp(vec x, vec y) {vec z;
  z.a[0] = x.a[1]*y.a[2] - x.a[2]*y.a[1];
  z.a[1] = x.a[2]*y.a[0] - x.a[0]*y.a[2];
  z.a[2] = x.a[0]*y.a[1] - x.a[1]*y.a[0]; return z;}
/* Inner product */
static float ip(vec e, vec f) {double s=0; int i;
   for(i=0; i<3; i++) s += e.a[i]*f.a[i]; return s;}

/* Construct a zone given its prefered shape and vertex list. */
typedef struct {short q[4];} int4;
static simp csimp(lt sh, int4 n, short m) {simp s;
  int i; s.mat=m; s.sh=sh; for (i=0; i<4; i++) s.v[i] = n.q[i]; return s;}
/* Invert a lower triangular matrix, yielding another lt matrix. */
static lt invd(lt x) {lt q; q.a = 1./x.a; q.c = 1./x.c;
  q.f = 1./x.f; q.b = -x.b*q.a*q.c; q.e = - x.e*q.c*q.f;
  q.d = -(q.a*x.d+q.b*x.e)*q.f; return q;}
/* sqz merely codes a lower trang. matrix into a shorter lt. */
static void sm(float x){if(x>0.00001 || x<-0.00001) 
{printf("Big %13.7f\n",x); exit(1);}}
static lt sqz(tri z) {lt x;
   sm(z.A[0].a[1]); sm(z.A[0].a[2]); sm(z.A[1].a[2]);
  x.a=z.A[0].a[0]; x.b=z.A[1].a[0]; x.c=z.A[1].a[1];
  x.d=z.A[2].a[0]; x.e=z.A[2].a[1]; x.f=z.A[2].a[2]; return x;}
/* Inverse of length of a vector */
static float il(vec e) {return 1./sqrt(ip(e, e));}
/* Scalar product */
static vec sp( float e, vec f)
  {vec v; int i; for (i=0; i<3; i++) v.a[i] = e*f.a[i]; return v;}
/* Grahm Schmidt */
static tri gs(tri t) {tri v; v.A[0]=sp(il(t.A[0]), t.A[0]);
  {vec x = vsub(t.A[1], sp(ip(t.A[1], v.A[0]), v.A[0])); v.A[1] = sp(il(x), x);}
  {vec x = vsub(vsub(t.A[2], sp(ip(t.A[2], v.A[0]), v.A[0])),
     sp(ip(t.A[2], v.A[1]), v.A[1]));
    v.A[2]=sp(il(x), x);} return v;}
/* Express a triad in terms of its own gs frame */
static tri rx(tri s) {tri sr; int i,j; tri st = gs(s);
  for (i=0; i<3; i++) for (j=0; j<3; j++)
     sr.A[i].a[j] = ip(s.A[i], st.A[j]); return sr;}
/* Compute a tetrahedron's "prefered" shape. */
static lt shape(tri s) {return invd(sqz(rx(s)));}
int damp=0;
/* Add a zone to world given its four verticies. */
int xx=0;
void cxsimp(int i, int j, int k, int l, int mater)
  {int4 q; vec a=cdvec(i,j), b=cdvec(i,k), c=cdvec(i,l); float mass;
  q.q[0]=i; q.q[1]=j; q.q[2]=k; q.q[3]=l;
  nz((zone){{i, j, k, l}});
  mass = ip(cp(a, b), c)/24.; 
  if(mass<=0) printf("mass=%11.5f %u %u %u %u\n", mass, i,j,k,l);
  u[i].mass+=mass; u[j].mass+=mass; u[k].mass+=mass; u[l].mass+=mass;
  zns[xx++]= csimp(shape((tri){{a,b,c}}), q, mater);}