#include <math.h>
#include "types.h"
#include "Bounce.h"
#include "physics.h"

/* Table of materials */ extern float mu[], lam[];
vec cdvec(int, int);
extern simp zns[];
extern int xx;
extern int cycle;
extern vert u[];
extern int damp; 
int cycle=0;
/* Scalar product */
static vec sp(float e, vec f)
  {vec v; int i; for (i=0; i<3; i++) v.a[i] = e*f.a[i]; return v;}
/* Transpose a matrix. */
static tri tp(tri x) {int i,j; tri y; for (i=0; i<3; i++) for (j=0; j<3; j++)
  y.A[i].a[j] = x.A[j].a[i]; return y;}
/* Cross product of two vectors */
static vec cp(vec x, vec y) {vec z;
  z.a[0] = x.a[1]*y.a[2] - x.a[2]*y.a[1];
  z.a[1] = x.a[2]*y.a[0] - x.a[0]*y.a[2];
  z.a[2] = x.a[0]*y.a[1] - x.a[1]*y.a[0]; return z;}
// inner product
static float ip(vec e, vec f) {double s=0; int i;
   for(i=0; i<3; i++) s += e.a[i]*f.a[i]; return s;}
static vec vadd(vec a, vec b) /* vector sum */
  {vec d; int i; for (i=0; i<3; i++) d.a[i]=a.a[i]+b.a[i]; return d;}
static vec vsub(vec a, vec b) /* vector difference */
  {vec d; int i; for (i=0; i<3; i++) d.a[i]=a.a[i]-b.a[i]; return d;}
/* Scalar times tensor */
static tri stp(float e, tri f)
  {tri v; int i; for (i=0; i<3; i++) v.A[i] = sp(e, f.A[i]); return v;}
/* Tensor times Vector */
static vec trivec(tri a, vec b) {vec c; int i; for (i=0; i<3; i++)
  c.a[i] = ip(a.A[i], b); return c;}
/* Product of a lt with a vector */
static vec ltvec(lt d, vec e) {vec r; r.a[0] = d.a*e.a[0];
  r.a[1] = d.b*e.a[0]+d.c*e.a[1];
  r.a[2] = d.d*e.a[0]+d.e*e.a[1]+d.f*e.a[2]; return r;}

/* Push on a vertex. */
static void shove(int i, vec f) {u[i].mom = vadd(u[i].mom, f);}
static tri push(lt sh, tri Or) {tri b=tp(Or), v, w; int i, j;
  for (i=0; i<3; i++) w.A[i] = ltvec(sh, b.A[i]);
  for (i=0; i<3; i++) for (j=0; j<=i; j++)
    v.A[j].a[i] = v.A[i].a[j] = ip(w.A[i], w.A[j]);
  return v;}
extern int n_vert;
void physics(float dt) {int i; 
   if(damp){int i; for (i=0; i<n_vert; i++) u[i].mom = sp(1-dt, u[i].mom);}
 /* Visit each zone. */ cycle++; for (i=0; i<xx; i++)
   {int n = zns[i].v[0]; float compress =0.;
   vec a=cdvec(n,zns[i].v[1]), b=cdvec(n,zns[i].v[2]), c=cdvec(n,zns[i].v[3]);
   tri strain = push(zns[i].sh, (tri){{a, b, c}});
   {int j; for (j=0; j<3; j++) compress +=(strain.A[j].a[j] -= 1.);}
    compress *= lam[zns[i].mat]*dt;
   {tri stress = stp(mu[zns[i].mat]*dt, strain); vec forth = (vec){{0,0,0}};
     int j; for (j=0; j<3; j++) stress.A[j].a[j] += compress; 
 {vec frc=trivec(stress, cp(a, b)); forth=vsub(forth, frc); shove(zns[i].v[3], frc);}
 {vec frc=trivec(stress, cp(b, c)); forth=vsub(forth, frc); shove(zns[i].v[1], frc);}
 {vec frc=trivec(stress, cp(c, a)); forth=vsub(forth, frc); shove(zns[i].v[2], frc);}
     shove(n, forth);}}
   {/* Visit each vertex. */ int i; for (i=0; i<n_vert; i++)
   {u[i].wh = vadd(u[i].wh, sp(dt/u[i].mass, u[i].mom));}}}
